<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

// 옵션
$wos = apms_options($options, $m_options);
$list = apms_board_rows($wos);
$list_cnt = count($list);
if(!$list_cnt) {
	echo '<span class="white">글이 없습니다.</span>'.PHP_EOL;	
	return;
}

// 효과
switch($wos['carousel']) {
	case 'fade'		: $effect = ' slide at-fade'; break;
	case 'up'		: $effect = ' slide at-vertical'; break;
	case 'slide'	: $effect = ' slide'; break;
	case 'show'		: $effect = ''; break;
	default			: $effect = ' slide'; break;
}

// 효과시간
$interval = ($wos['interval']) ? $wos['interval'] : 5000;

// Random Ticker Id
$carousel_id = apms_id();

?>

<div class="carousel<?php echo $effect;?> widget-newsticker" id="<?php echo $carousel_id;?>" data-ride="carousel" data-interval="<?php echo $interval;?>">
	<div class="carousel-inner">
		<?php for ($i=0; $i < $list_cnt; $i++) { ?>
			<div class="item<?php echo ($i == 0) ? ' active' : '';?>">
				<a href="<?php echo $list[$i]['href'];?>">
					<?php if($wos['rank']) { ?>
						<span class="en widget-rank-icon widget-rank-<?php echo $wos['rank'];?>"><?php echo $i+1;?></span>
					<?php } else { ?>
						<i class="fa <?php echo $wos['icon'];?>"></i>
					<?php } ?>
					<?php echo $list[$i]['subject'];?>
					<span class="info">
						<?php if($list[$i]['comment']) { ?>
							<i class="fa fa-comments"></i> <?php echo $list[$i]['comment'];?>
						<?php } ?>
						<i class="fa fa-clock-o"></i> <?php echo apms_datetime($list[$i]['date'], 'm.d');?>
					</span>
				</a> 
			</div>
		<?php } ?>
	</div>
</div>
